#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define DOSINT 0x21

/* ------- test to see if the program is already resident
		if found, return data segment ---------- */

typedef struct mcb_s {
	char id;
	unsigned psp;
	unsigned len;
	char junk[3];
	char name[8];
} MCB;

char signature[] = "InetFTPServer";


// To determine put a breakpoint at unsigned resident(char *signature)

unsigned wSignatureSegment = 0x85b;	// _DS - _psp
unsigned wSignatureOffset = 0x20f;  // FP_OFF(signature)

int main(void)
{
	MCB far * pmcb;
	unsigned mcbseg;

	_AH = 0x52;
	geninterrupt(DOSINT);
	mcbseg = _ES;
	mcbseg = peek(mcbseg, _BX - 2);
	pmcb = MK_FP(mcbseg,0);
	while (1) {
		if (pmcb->id == 'Z') {
			printf("FTP server not resident\n");
			exit(1);
			return 1;
		}
		else if (pmcb->id == 'M') {
			if (pmcb->psp && pmcb->psp != _psp &&
						_fstrcmp(signature,MK_FP(pmcb->psp + wSignatureSegment,
												wSignatureOffset)) == 0) {
				printf("FTP Server is resident\n");
				exit(0);
			}
		}
		else {
			printf("DOS memory corruption\n");
			exit(2);
		}
		FP_SEG(pmcb) += pmcb->len + 1;
	}
}
